///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND StatusBar_hWnd = NULL;
    static HMENU SystemMenu = NULL;

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1002, "www.NetWorkDLS.com");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption" :: Results");
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM)LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        HMENU MainMenu_hMenu = LoadMenu(MainInstance, MAKEINTRESOURCE(IDR_MAIN) );
        SetMenu(xHandle, MainMenu_hMenu);

        StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Scanning, Please wait...", xHandle, 1);

        LanViewListBox_hWnd = GetDlgItem(xHandle, IDC_LANLIEWLISTBOX);

        SendMessage(LanViewListBox_hWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

        MyImageList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), TRUE, 1, 1);

        HICON hIcon = NULL;

        hIcon = LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_NETCOMPON));
        ImageList_AddIcon(MyImageList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_NETCOMPOFF));
        ImageList_AddIcon(MyImageList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        ListView_SetImageList(LanViewListBox_hWnd, MyImageList, LVSIL_SMALL);

        LV_COLUMN MyLVColumb;
        memset(&MyLVColumb, 0, sizeof(LV_COLUMN));

        MyLVColumb.cx        = 20;
        MyLVColumb.pszText   = " ";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(LanViewListBox_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 125;
        MyLVColumb.pszText   = "Network Resource";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(LanViewListBox_hWnd, 1, &MyLVColumb);

        MyLVColumb.cx        = 200;
        MyLVColumb.pszText   = "Host Name";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(LanViewListBox_hWnd, 2, &MyLVColumb);

		MyLVColumb.cx        = 100;
        MyLVColumb.pszText   = "IP Address";
        MyLVColumb.iSubItem  = 3;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(LanViewListBox_hWnd, 3, &MyLVColumb);

        MyLVColumb.cx        = 120;
        MyLVColumb.pszText   = "MAC Address";
        MyLVColumb.iSubItem  = 4;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(LanViewListBox_hWnd, 4, &MyLVColumb);

        MyLVColumb.cx        = 140;
        MyLVColumb.pszText   = "Resource Comment";
        MyLVColumb.iSubItem  = 5;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(LanViewListBox_hWnd, 5, &MyLVColumb);

        RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(LanViewListBox_hWnd, 0, 0, WindowRECT.right, WindowRECT.bottom - 21, TRUE);
        MoveWindow(StatusBar_hWnd, WindowRECT.right-20, WindowRECT.bottom-20, WindowRECT.right, WindowRECT.bottom, TRUE);

        char SBText[255];

        if(DialogBox(MainInstance, MAKEINTRESOURCE(IDD_SCANNING), 0, ScanningDialog) != 1234)
            sprintf(SBText, " Found %d Machines. Canceled.", giContainerCount);
        else sprintf(SBText, " Found %d Machines.", giContainerCount);

        SendMessage(StatusBar_hWnd, (UINT)SB_SETTEXT, (WPARAM)0, (LPARAM)SBText);

        CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE)
    {
        int nWidth  = LOWORD(lParam);
        int nHeight = HIWORD(lParam);

        MoveWindow(LanViewListBox_hWnd, 0, 0, nWidth, nHeight - 21, TRUE);
        MoveWindow(StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);

        return TRUE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == ID_HELP_ABOUT)
        {
            NetLogo(xHandle);
            return TRUE;
        }

        if(wParam == ID_FILE_EXIT)
        {
            EndDialog(xHandle,0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            NetLogo(xHandle);
            return TRUE;
        }

        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s", TitleCaption, FileVersion);
            MessageBox(xHandle, VersionText, "Application Version", MB_TASKMODAL);
            return TRUE;
        }

        if(LOWORD(wParam) == 1002) //- www.NetWorkDLS.com (SysMenu Command)
        {
            ShellExecute(0,"Open", "Http://www.NetWorkDLS.com", NULL, NULL, SW_SHOWNORMAL);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

